﻿local BabbleTrade=AceLibrary("Babble-Tradeskill-2.2");
local BabbleFaction = AceLibrary("Babble-Faction-2.2");
local BabbleClass = AceLibrary("Babble-Class-2.2");
local BabbleZone = AceLibrary("Babble-Zone-2.2");
local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot"); 

-- Colours stored for code readability
local GREY = "|cff999999";
local RED = "|cffff0000";
local WHITE = "|cffFFFFFF";
local GREEN = "|cff1eff00";
local PURPLE = "|cff9F3FFF";
local BLUE = "|cff0070dd";
local ORANGE = "|cffFF8400";

AtlasLoot_ButtonRegistry = {
    ["Thorium1"] = {
        Title = BabbleFaction["Thorium Brotherhood"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Next_Page = "Thorium2";
        Next_Title = BabbleFaction["Thorium Brotherhood"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Thorium2"] = {
        Title = BabbleFaction["Thorium Brotherhood"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Prev_Page = "Thorium1";
        Prev_Title = BabbleFaction["Thorium Brotherhood"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Cenarion1"] = {
        Title = BabbleFaction["Cenarion Circle"]..": "..BabbleFaction["Friendly"];
        Next_Page = "Cenarion2";
        Next_Title = BabbleFaction["Cenarion Circle"]..": "..BabbleFaction["Honored"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Cenarion2"] = {
        Title = BabbleFaction["Cenarion Circle"]..": "..BabbleFaction["Honored"];
        Next_Page = "Cenarion3";
        Next_Title = BabbleFaction["Cenarion Circle"]..": "..BabbleFaction["Revered"];
        Prev_Page = "Cenarion1";
        Prev_Title = BabbleFaction["Cenarion Circle"]..": "..BabbleFaction["Friendly"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Cenarion3"] = {
        Title = BabbleFaction["Cenarion Circle"]..": "..BabbleFaction["Revered"];
        Next_Page = "Cenarion4";
        Next_Title = BabbleFaction["Cenarion Circle"]..": "..BabbleFaction["Exalted"];
        Prev_Page = "Cenarion2";
        Prev_Title = BabbleFaction["Cenarion Circle"]..": "..BabbleFaction["Honored"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Cenarion4"] = {
        Title = BabbleFaction["Cenarion Circle"]..": "..BabbleFaction["Exalted"];
        Prev_Page = "Cenarion3";
        Prev_Title = BabbleFaction["Cenarion Circle"]..": "..BabbleFaction["Revered"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Argent1"] = {
        Title = BabbleFaction["Argent Dawn"]..": "..AL["Token Hand-Ins"];
        Next_Page = "Argent2";
        Next_Title = BabbleFaction["Argent Dawn"]..": "..BabbleFaction["Friendly"].."-"..BabbleFaction["Exalted"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Argent2"] = {
        Title = BabbleFaction["Argent Dawn"]..": "..BabbleFaction["Friendly"].."-"..BabbleFaction["Exalted"];
        Prev_Page = "Argent1";
        Prev_Title = BabbleFaction["Argent Dawn"]..": "..AL["Token Hand-Ins"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Zandalar1"] = {
        Title = BabbleFaction["Zandalar Tribe"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Next_Page = "Zandalar2";
        Next_Title = BabbleFaction["Zandalar Tribe"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Zandalar2"] = {
        Title = BabbleFaction["Zandalar Tribe"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Prev_Page = "Zandalar1";
        Prev_Title = BabbleFaction["Zandalar Tribe"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Bloodsail1"] = {
        Title = BabbleFaction["Bloodsail Buccaneers"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["AQBroodRings"] = {
        Title = BabbleFaction["Brood of Nozdormu"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Darkmoon1"] = {
        Title = BabbleFaction["Darkmoon Faire"];
        Next_Page = "Darkmoon2";
        Next_Title = AtlasLoot_TableNames["Darkmoon2"][1];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Darkmoon2"] = {
        Title = AtlasLoot_TableNames["Darkmoon2"][1];
        Prev_Page = "Darkmoon1";
        Prev_Title = BabbleFaction["Darkmoon Faire"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Frostwolf1"] = {
        Title = BabbleFaction["Frostwolf Clan"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["WaterLords1"] = {
        Title = BabbleFaction["Hydraxian Waterlords"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Stormpike1"] = {
        Title = BabbleFaction["Stormpike Guard"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Timbermaw"] = {
        Title = BabbleFaction["Timbermaw Hold"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Wintersaber1"] = {
        Title = BabbleFaction["Wintersaber Trainers"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["GelkisClan1"] = {
        Title = BabbleFaction["Gelkis Clan Centaur"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["MagramClan1"] = {
        Title = BabbleFaction["Magram Clan Centaur"];
        Back_Page = "REPMENU_AZEROTHPREBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Pre-Burning Crusade"];
        };
    ["Aldor1"] = {
        Title = BabbleFaction["The Aldor"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Next_Page = "Aldor2";
        Next_Title = BabbleFaction["The Aldor"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Back_Page = "REPMENU_SHATTRATH";
        Back_Title = AL["Factions - Shattrath City"];
        };
    ["Aldor2"] = {
        Title = BabbleFaction["The Aldor"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Prev_Page = "Aldor1";
        Prev_Title = BabbleFaction["The Aldor"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Back_Page = "REPMENU_SHATTRATH";
        Back_Title = AL["Factions - Shattrath City"];
        };
    ["Scryer1"] = {
        Title = BabbleFaction["The Scryers"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Next_Page = "Scryer2";
        Next_Title = BabbleFaction["The Scryers"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Back_Page = "REPMENU_SHATTRATH";
        Back_Title = AL["Factions - Shattrath City"];
        };
    ["Scryer2"] = {
        Title = BabbleFaction["The Scryers"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Prev_Page = "Scryer1";
        Prev_Title = BabbleFaction["The Scryers"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Back_Page = "REPMENU_SHATTRATH";
        Back_Title = AL["Factions - Shattrath City"];
        };
    ["CExpedition1"] = {
        Title = BabbleFaction["Cenarion Expedition"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Next_Page = "CExpedition2";
        Next_Title = BabbleFaction["Cenarion Expedition"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["CExpedition2"] = {
        Title = BabbleFaction["Cenarion Expedition"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Prev_Page = "CExpedition1";
        Prev_Title = BabbleFaction["Cenarion Expedition"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["Thrallmar1"] = {
        Title = BabbleFaction["Thrallmar"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Next_Page = "Thrallmar2";
        Next_Title = BabbleFaction["Thrallmar"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["Thrallmar2"] = {
        Title = BabbleFaction["Thrallmar"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Prev_Page = "Thrallmar1";
        Prev_Title = BabbleFaction["Thrallmar"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["HonorHold1"] = {
        Title = BabbleFaction["Honor Hold"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Next_Page = "HonorHold2";
        Next_Title = BabbleFaction["Honor Hold"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["HonorHold2"] = {
        Title = BabbleFaction["Honor Hold"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Prev_Page = "HonorHold1";
        Prev_Title = BabbleFaction["Honor Hold"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["Consortium1"] = {
        Title = BabbleFaction["The Consortium"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Next_Page = "Consortium2";
        Next_Title = BabbleFaction["The Consortium"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["Consortium2"] = {
        Title = BabbleFaction["The Consortium"]..": "..BabbleFaction["Revered"].."/"..BabbleFaction["Exalted"];
        Prev_Page = "Consortium1";
        Prev_Title = BabbleFaction["The Consortium"]..": "..BabbleFaction["Friendly"].."/"..BabbleFaction["Honored"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["ScaleSands1"] = {
        Title = BabbleFaction["The Scale of the Sands"];
        Next_Page = "ScaleSands2";
        Next_Title = BabbleFaction["The Scale of the Sands"]..": "..BabbleFaction["Friendly"].."-"..BabbleFaction["Exalted"];
        Back_Page = "REPMENU_AZEROTHPOSTBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Post-Burning Crusade"];
        };
    ["ScaleSands2"] = {
        Title = BabbleFaction["The Scale of the Sands"]..": "..BabbleFaction["Friendly"].."-"..BabbleFaction["Exalted"];
        Prev_Page = "ScaleSands1";
        Prev_Title = BabbleFaction["The Scale of the Sands"];
        Back_Page = "REPMENU_AZEROTHPOSTBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Post-Burning Crusade"];
        };
    ["Ashtongue1"] = {
        Title = BabbleFaction["Ashtongue Deathsworn"];
        Next_Page = "Ashtongue2";
        Next_Title = BabbleFaction["Ashtongue Deathsworn"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["Ashtongue2"] = {
        Title = BabbleFaction["Ashtongue Deathsworn"];
        Prev_Page = "Ashtongue1";
        Prev_Title = BabbleFaction["Ashtongue Deathsworn"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["Netherwing1"] = {
        Title = BabbleFaction["Netherwing"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["Skyguard1"] = {
        Title = BabbleFaction["Sha'tari Skyguard"];
        Back_Page = "REPMENU_SHATTRATH";
        Back_Title = AL["Factions - Shattrath City"];
        };
    ["Ogrila1"] = {
        Title = BabbleFaction["Ogri'la"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["KeepersofTime1"] = {
        Title = BabbleFaction["Keepers of Time"];
        Back_Page = "REPMENU_AZEROTHPOSTBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Post-Burning Crusade"];
        };
    ["Kurenai1"] = {
        Title = BabbleFaction["Kurenai"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["LowerCity1"] = {
        Title = BabbleFaction["Lower City"];
        Back_Page = "REPMENU_SHATTRATH";
        Back_Title = AL["Factions - Shattrath City"];
        };
    ["Maghar1"] = {
        Title = BabbleFaction["The Mag'har"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["Shatar1"] = {
        Title = BabbleFaction["The Sha'tar"];
        Back_Page = "REPMENU_SHATTRATH";
        Back_Title = AL["Factions - Shattrath City"];
        };
    ["Sporeggar1"] = {
        Title = BabbleFaction["Sporeggar"];
        Back_Page = "REPMENU_OUTLAND";
        Back_Title = AL["Factions - Outland"];
        };
    ["Tranquillien1"] = {
        Title = BabbleFaction["Tranquillien"];
        Back_Page = "REPMENU_AZEROTHPOSTBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Post-Burning Crusade"];
        };
    ["VioletEye1"] = {
        Title = BabbleFaction["The Violet Eye"];
        Next_Page = "VioletEye2";
        Next_Title = BabbleFaction["The Violet Eye"];
        Back_Page = "REPMENU_AZEROTHPOSTBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Post-Burning Crusade"];
        };
    ["VioletEye2"] = {
        Title = BabbleFaction["The Violet Eye"];
        Prev_Page = "VioletEye1";
        Prev_Title = BabbleFaction["The Violet Eye"];
        Back_Page = "REPMENU_AZEROTHPOSTBC";
        Back_Title = AL["Factions - Azeroth"].." : "..AL["Post-Burning Crusade"];
        };
    ["Tabards1"] = {
        Title = AtlasLoot_TableNames["Tabards1"][1];
        Next_Page = "Tabards2";
        Next_Title = AtlasLoot_TableNames["Tabards2"][1];
        };
    ["Tabards2"] = {
        Title = AtlasLoot_TableNames["Tabards2"][1];
        Prev_Page = "Tabards1";
        Prev_Title = AtlasLoot_TableNames["Tabards1"][1];
        };
    ["AVMisc"] = {
        Title = BabbleZone["Alterac Valley"]..": "..AL["Misc. Rewards"];
        Next_Page = "AVBlue";
        Next_Title = BabbleZone["Alterac Valley"]..": "..AL["Superior Rewards"];
        };
    ["AVBlue"] = {
        Title = BabbleZone["Alterac Valley"]..": "..AL["Superior Rewards"];
        Next_Page = "AVPurple";
        Next_Title = BabbleZone["Alterac Valley"]..": "..AL["Epic Rewards"];
        Prev_Page = "AVMisc";
        Prev_Title = BabbleZone["Alterac Valley"]..": "..AL["Misc. Rewards"];
        };
    ["AVPurple"] = {
        Title = BabbleZone["Alterac Valley"]..": "..AL["Epic Rewards"];
        Prev_Page = "AVBlue";
        Prev_Title = BabbleZone["Alterac Valley"]..": "..AL["Superior Rewards"];
        };
    ["ABMisc"] = {
        Title = BabbleZone["Arathi Basin"]..": "..AL["Misc. Rewards"];
        Next_Page = "ABBlue";
        Next_Title = BabbleZone["Arathi Basin"]..": "..AL["Superior Rewards"];
        };
    ["ABBlue"] = {
        Title = BabbleZone["Arathi Basin"]..": "..AL["Superior Rewards"];
        Next_Page = "ABPurple";
        Next_Title = BabbleZone["Arathi Basin"]..": "..AL["Epic Rewards"];
        Prev_Page = "ABMisc";
        Prev_Title = BabbleZone["Arathi Basin"]..": "..AL["Misc. Rewards"];
        };
    ["ABPurple"] = {
        Title = BabbleZone["Arathi Basin"]..": "..AL["Epic Rewards"];
        Next_Page = "ABSets1";
        Next_Title = AtlasLoot_TableNames["ABSets1"][1];
        Prev_Page = "ABBlue";
        Prev_Title = BabbleZone["Arathi Basin"]..": "..AL["Superior Rewards"];
        };
    ["ABSets1"] = {
        Title = AtlasLoot_TableNames["ABSets1"][1];
        Next_Page = "ABSets2";
        Next_Title = AtlasLoot_TableNames["ABSets2"][1];
        Prev_Page = "ABPurple";
        Prev_Title = BabbleZone["Arathi Basin"]..": "..AL["Epic Rewards"];
        };
    ["ABSets2"] = {
        Title = AtlasLoot_TableNames["ABSets2"][1];
        Prev_Page = "ABSets1";
        Prev_Title = AtlasLoot_TableNames["ABSets1"][1];
        };
    ["WSGMisc"] = {
        Title = BabbleZone["Warsong Gulch"]..": "..AL["Misc. Rewards"];
        Next_Page = "WSGBlue";
        Next_Title = BabbleZone["Warsong Gulch"]..": "..AL["Superior Rewards"];
        };
    ["WSGBlue"] = {
        Title = BabbleZone["Warsong Gulch"]..": "..AL["Superior Rewards"];
        Next_Page = "WSGPurple";
        Next_Title = BabbleZone["Warsong Gulch"]..": "..AL["Epic Rewards"];
        Prev_Page = "WSGMisc";
        Prev_Title = BabbleZone["Warsong Gulch"]..": "..AL["Misc. Rewards"];
        };
    ["WSGPurple"] = {
        Title = BabbleZone["Warsong Gulch"]..": "..AL["Epic Rewards"];
        Prev_Page = "WSGBlue";
        Prev_Title = BabbleZone["Warsong Gulch"]..": "..AL["Superior Rewards"];
        };
    ["Nagrand1"] = {
        Title = BabbleZone["Nagrand"];
        Next_Page = "Nagrand2";
        Next_Title = BabbleZone["Nagrand"];
        };
    ["Nagrand2"] = {
        Title = BabbleZone["Nagrand"];
        Prev_Page = "Nagrand1";
        Prev_Title = BabbleZone["Nagrand"];
        };
    ["PvP60Accessories1"] = {
        Title = AtlasLoot_TableNames["PvP60Accessories1"][1];
        Next_Page = "PvP60Accessories2";
        Next_Title = AtlasLoot_TableNames["PvP60Accessories2"][1];
        };
    ["PvP60Accessories2"] = {
        Title = AtlasLoot_TableNames["PvP60Accessories2"][1];
        Next_Page = "PvP60Accessories3";
        Next_Title = AtlasLoot_TableNames["PvP60Accessories3"][1];
        Prev_Page = "PvP60Accessories1";
        Prev_Title = AtlasLoot_TableNames["PvP60Accessories1"][1];
        };
    ["PvP60Accessories3"] = {
        Title = AtlasLoot_TableNames["PvP60Accessories3"][1];
        Prev_Page = "PvP60Accessories2";
        Prev_Title = AtlasLoot_TableNames["PvP60Accessories2"][1];
        };
    ["PvP70Accessories1"] = {
        Title = AL["PvP Accessories"];
        Next_Page = "PvP70Accessories2";
        Next_Title = AL["PvP Accessories"];
        };
    ["PvP70Accessories2"] = {
        Title = AL["PvP Accessories"];
        Prev_Page = "PvP70Accessories1";
        Prev_Title = AL["PvP Accessories"];
        };
    ["PVPWeapons1"] = {
        Title = AL["PvP Weapons"];
        Next_Page = "PVPWeapons2";
        Next_Title = AL["PvP Weapons"];
        };
    ["PVPWeapons2"] = {
        Title = AL["PvP Weapons"];
        Prev_Page = "PVPWeapons1";
        Prev_Title = AL["PvP Weapons"];
        };
    ["PVP70Weapons1"] = {
        Title = AL["PvP Weapons"];
        Next_Page = "PVP70Weapons2";
        Next_Title = AL["PvP Weapons"];
        };
    ["PVP70Weapons2"] = {
        Title = AL["PvP Weapons"];
        Prev_Page = "PVP70Weapons1";
        Prev_Title = AL["PvP Weapons"];
        };
    ["PvP70NonSet1"] = {
        Title = AtlasLoot_TableNames["PvP70NonSet1"][1];
        Next_Page = "PvP70NonSet2";
        Next_Title = AtlasLoot_TableNames["PvP70NonSet2"][1];
        Back_Page = "PVP70NONSETEPICS";
        Back_Title = AL["PvP Non-Set Epics"];
        };
    ["PvP70NonSet2"] = {
        Title = AtlasLoot_TableNames["PvP70NonSet2"][1];
        Next_Page = "PvP70NonSet3";
        Next_Title = AtlasLoot_TableNames["PvP70NonSet3"][1];
        Prev_Page = "PvP70NonSet1";
        Prev_Title = AtlasLoot_TableNames["PvP70NonSet1"][1];
        Back_Page = "PVP70NONSETEPICS";
        Back_Title = AL["PvP Non-Set Epics"];
        };
    ["PvP70NonSet3"] = {
        Title = AtlasLoot_TableNames["PvP70NonSet3"][1];
        Next_Page = "PvP70NonSet4";
        Next_Title = AtlasLoot_TableNames["PvP70NonSet4"][1];
        Prev_Page = "PvP70NonSet2";
        Prev_Title = AtlasLoot_TableNames["PvP70NonSet2"][1];
        Back_Page = "PVP70NONSETEPICS";
        Back_Title = AL["PvP Non-Set Epics"];
        };
    ["PvP70NonSet4"] = {
        Title = AtlasLoot_TableNames["PvP70NonSet4"][1];
        Next_Page = "PvP70NonSet5";
        Next_Title = AtlasLoot_TableNames["PvP70NonSet5"][1];
        Prev_Page = "PvP70NonSet3";
        Prev_Title = AtlasLoot_TableNames["PvP70NonSet3"][1];
        Back_Page = "PVP70NONSETEPICS";
        Back_Title = AL["PvP Non-Set Epics"];
        };
    ["PvP70NonSet5"] = {
        Title = AtlasLoot_TableNames["PvP70NonSet5"][1];
        Prev_Page = "PvP70NonSet4";
        Prev_Title = AtlasLoot_TableNames["PvP70NonSet4"][1];
        Back_Page = "PVP70NONSETEPICS";
        Back_Title = AL["PvP Non-Set Epics"];
        };
    ["AQ40Druid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "AQ40SET";
        Back_Title = AL["Temple of Ahn'Qiraj Sets"];
        };
    ["AQ40Hunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "AQ40SET";
        Back_Title = AL["Temple of Ahn'Qiraj Sets"];
        };
    ["AQ40Mage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "AQ40SET";
        Back_Title = AL["Temple of Ahn'Qiraj Sets"];
        };
    ["AQ40Paladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "AQ40SET";
        Back_Title = AL["Temple of Ahn'Qiraj Sets"];
        };
    ["AQ40Priest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "AQ40SET";
        Back_Title = AL["Temple of Ahn'Qiraj Sets"];
        };
    ["AQ40Rogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "AQ40SET";
        Back_Title = AL["Temple of Ahn'Qiraj Sets"];
        };
    ["AQ40Shaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "AQ40SET";
        Back_Title = AL["Temple of Ahn'Qiraj Sets"];
        };
    ["AQ40Warlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "AQ40SET";
        Back_Title = AL["Temple of Ahn'Qiraj Sets"];
        };
    ["AQ40Warrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "AQ40SET";
        Back_Title = AL["Temple of Ahn'Qiraj Sets"];
        };
    ["AQ20Druid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "AQ20SET";
        Back_Title = AL["Ruins of Ahn'Qiraj Sets"];
        };
    ["AQ20Hunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "AQ20SET";
        Back_Title = AL["Ruins of Ahn'Qiraj Sets"];
        };
    ["AQ20Mage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "AQ20SET";
        Back_Title = AL["Ruins of Ahn'Qiraj Sets"];
        };
    ["AQ20Paladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "AQ20SET";
        Back_Title = AL["Ruins of Ahn'Qiraj Sets"];
        };
    ["AQ20Priest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "AQ20SET";
        Back_Title = AL["Ruins of Ahn'Qiraj Sets"];
        };
    ["AQ20Rogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "AQ20SET";
        Back_Title = AL["Ruins of Ahn'Qiraj Sets"];
        };
    ["AQ20Shaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "AQ20SET";
        Back_Title = AL["Ruins of Ahn'Qiraj Sets"];
        };
    ["AQ20Warlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "AQ20SET";
        Back_Title = AL["Ruins of Ahn'Qiraj Sets"];
        };
    ["AQ20Warrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "AQ20SET";
        Back_Title = AL["Ruins of Ahn'Qiraj Sets"];
        };
    ["ZGDruid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "ZGSET";
        Back_Title = AL["Zul'Gurub Sets"];
        };
    ["ZGHunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "ZGSET";
        Back_Title = AL["Zul'Gurub Sets"];
        };
    ["ZGMage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "ZGSET";
        Back_Title = AL["Zul'Gurub Sets"];
        };
    ["ZGPaladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "ZGSET";
        Back_Title = AL["Zul'Gurub Sets"];
        };
    ["ZGPriest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "ZGSET";
        Back_Title = AL["Zul'Gurub Sets"];
        };
    ["ZGRogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "ZGSET";
        Back_Title = AL["Zul'Gurub Sets"];
        };
    ["ZGShaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "ZGSET";
        Back_Title = AL["Zul'Gurub Sets"];
        };
    ["ZGWarlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "ZGSET";
        Back_Title = AL["Zul'Gurub Sets"];
        };
    ["ZGWarrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "ZGSET";
        Back_Title = AL["Zul'Gurub Sets"];
        };
    ["ArenaDruid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "ARENASET";
        Back_Title = AL["Arena PvP Sets"];
        };
    ["ArenaHunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "ARENASET";
        Back_Title = AL["Arena PvP Sets"];
        };
    ["ArenaMage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "ARENASET";
        Back_Title = AL["Arena PvP Sets"];
        };
    ["ArenaPaladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "ARENASET";
        Back_Title = AL["Arena PvP Sets"];
        };
    ["ArenaPriest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "ARENASET";
        Back_Title = AL["Arena PvP Sets"];
        };
    ["ArenaRogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "ARENASET";
        Back_Title = AL["Arena PvP Sets"];
        };
    ["ArenaShaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "ARENASET";
        Back_Title = AL["Arena PvP Sets"];
        };
    ["ArenaWarlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "ARENASET";
        Back_Title = AL["Arena PvP Sets"];
        };
    ["ArenaWarrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "ARENASET";
        Back_Title = AL["Arena PvP Sets"];
        };
    ["Arena2Druid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "ARENA2SET";
        Back_Title = AL["Arena 2 PvP Sets"];
        };
    ["Arena2Hunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "ARENA2SET";
        Back_Title = AL["Arena 2 PvP Sets"];
        };
    ["Arena2Mage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "ARENA2SET";
        Back_Title = AL["Arena 2 PvP Sets"];
        };
    ["Arena2Paladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "ARENA2SET";
        Back_Title = AL["Arena 2 PvP Sets"];
        };
    ["Arena2Priest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "ARENA2SET";
        Back_Title = AL["Arena 2 PvP Sets"];
        };
    ["Arena2Rogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "ARENA2SET";
        Back_Title = AL["Arena 2 PvP Sets"];
        };
    ["Arena2Shaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "ARENA2SET";
        Back_Title = AL["Arena 2 PvP Sets"];
        };
    ["Arena2Warlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "ARENA2SET";
        Back_Title = AL["Arena 2 PvP Sets"];
        };
    ["Arena2Warrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "ARENA2SET";
        Back_Title = AL["Arena 2 PvP Sets"];
        };
    ["T0Druid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "T0SET";
        Back_Title = AL["Dungeon 1/2 Sets"];
        };
    ["T0Hunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "T0SET";
        Back_Title = AL["Dungeon 1/2 Sets"];
        };
    ["T0Mage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "T0SET";
        Back_Title = AL["Dungeon 1/2 Sets"];
        };
    ["T0Paladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "T0SET";
        Back_Title = AL["Dungeon 1/2 Sets"];
        };
    ["T0Priest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "T0SET";
        Back_Title = AL["Dungeon 1/2 Sets"];
        };
    ["T0Rogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "T0SET";
        Back_Title = AL["Dungeon 1/2 Sets"];
        };
    ["T0Shaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "T0SET";
        Back_Title = AL["Dungeon 1/2 Sets"];
        };
    ["T0Warlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "T0SET";
        Back_Title = AL["Dungeon 1/2 Sets"];
        };
    ["T0Warrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "T0SET";
        Back_Title = AL["Dungeon 1/2 Sets"];
        };
    ["T1Druid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "T1SET";
        Back_Title = AL["Tier 1 Sets"];
        };
    ["T1Hunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "T1SET";
        Back_Title = AL["Tier 1 Sets"];
        };
    ["T1Mage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "T1SET";
        Back_Title = AL["Tier 1 Sets"];
        };
    ["T1Paladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "T1SET";
        Back_Title = AL["Tier 1 Sets"];
        };
    ["T1Priest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "T1SET";
        Back_Title = AL["Tier 1 Sets"];
        };
    ["T1Rogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "T1SET";
        Back_Title = AL["Tier 1 Sets"];
        };
    ["T1Shaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "T1SET";
        Back_Title = AL["Tier 1 Sets"];
        };
    ["T1Warlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "T1SET";
        Back_Title = AL["Tier 1 Sets"];
        };
    ["T1Warrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "T1SET";
        Back_Title = AL["Tier 1 Sets"];
        };
    ["T2Druid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "T2SET";
        Back_Title = AL["Tier 2 Sets"];
        };
    ["T2Hunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "T2SET";
        Back_Title = AL["Tier 2 Sets"];
        };
    ["T2Mage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "T2SET";
        Back_Title = AL["Tier 2 Sets"];
        };
    ["T2Paladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "T2SET";
        Back_Title = AL["Tier 2 Sets"];
        };
    ["T2Priest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "T2SET";
        Back_Title = AL["Tier 2 Sets"];
        };
    ["T2Rogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "T2SET";
        Back_Title = AL["Tier 2 Sets"];
        };
    ["T2Shaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "T2SET";
        Back_Title = AL["Tier 2 Sets"];
        };
    ["T2Warlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "T2SET";
        Back_Title = AL["Tier 2 Sets"];
        };
    ["T2Warrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "T2SET";
        Back_Title = AL["Tier 2 Sets"];
        };
    ["T3Druid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "T3SET";
        Back_Title = AL["Tier 3 Sets"];
        };
    ["T3Hunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "T3SET";
        Back_Title = AL["Tier 3 Sets"];
        };
    ["T3Mage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "T3SET";
        Back_Title = AL["Tier 3 Sets"];
        };
    ["T3Paladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "T3SET";
        Back_Title = AL["Tier 3 Sets"];
        };
    ["T3Priest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "T3SET";
        Back_Title = AL["Tier 3 Sets"];
        };
    ["T3Rogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "T3SET";
        Back_Title = AL["Tier 3 Sets"];
        };
    ["T3Shaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "T3SET";
        Back_Title = AL["Tier 3 Sets"];
        };
    ["T3Warlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "T3SET";
        Back_Title = AL["Tier 3 Sets"];
        };
    ["T3Warrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "T3SET";
        Back_Title = AL["Tier 3 Sets"];
        };
    ["T4Druid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "T4SET";
        Back_Title = AL["Tier 4 Sets"];
        };
    ["T4Hunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "T4SET";
        Back_Title = AL["Tier 4 Sets"];
        };
    ["T4Mage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "T4SET";
        Back_Title = AL["Tier 4 Sets"];
        };
    ["T4Paladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "T4SET";
        Back_Title = AL["Tier 4 Sets"];
        };
    ["T4Priest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "T4SET";
        Back_Title = AL["Tier 4 Sets"];
        };
    ["T4Rogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "T4SET";
        Back_Title = AL["Tier 4 Sets"];
        };
    ["T4Shaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "T4SET";
        Back_Title = AL["Tier 4 Sets"];
        };
    ["T4Warlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "T4SET";
        Back_Title = AL["Tier 4 Sets"];
        };
    ["T4Warrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "T4SET";
        Back_Title = AL["Tier 4 Sets"];
        };
    ["T5Druid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "T5SET";
        Back_Title = AL["Tier 5 Sets"];
        };
    ["T5Hunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "T5SET";
        Back_Title = AL["Tier 5 Sets"];
        };
    ["T5Mage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "T5SET";
        Back_Title = AL["Tier 5 Sets"];
        };
    ["T5Paladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "T5SET";
        Back_Title = AL["Tier 5 Sets"];
        };
    ["T5Priest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "T5SET";
        Back_Title = AL["Tier 5 Sets"];
        };
    ["T5Rogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "T5SET";
        Back_Title = AL["Tier 5 Sets"];
        };
    ["T5Shaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "T5SET";
        Back_Title = AL["Tier 5 Sets"];
        };
    ["T5Warlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "T5SET";
        Back_Title = AL["Tier 5 Sets"];
        };
    ["T5Warrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "T5SET";
        Back_Title = AL["Tier 5 Sets"];
        };
    ["T6Druid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "T6SET";
        Back_Title = AL["Tier 6 Sets"];
        };
    ["T6Hunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "T6SET";
        Back_Title = AL["Tier 6 Sets"];
        };
    ["T6Mage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "T6SET";
        Back_Title = AL["Tier 6 Sets"];
        };
    ["T6Paladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "T6SET";
        Back_Title = AL["Tier 6 Sets"];
        };
    ["T6Priest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "T6SET";
        Back_Title = AL["Tier 6 Sets"];
        };
    ["T6Rogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "T6SET";
        Back_Title = AL["Tier 6 Sets"];
        };
    ["T6Shaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "T6SET";
        Back_Title = AL["Tier 6 Sets"];
        };
    ["T6Warlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "T6SET";
        Back_Title = AL["Tier 6 Sets"];
        };
    ["T6Warrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "T6SET";
        Back_Title = AL["Tier 6 Sets"];
        };
    ["PVPDruid"] = {
        Title = BabbleClass["Druid"];
        Back_Page = "PVPSET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVPHunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "PVPSET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVPMage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "PVPSET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVPPaladin"] = {
        Title = BabbleClass["Paladin"];
        Back_Page = "PVPSET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVPPriest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "PVPSET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVPRogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "PVPSET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVPShaman"] = {
        Title = BabbleClass["Shaman"];
        Back_Page = "PVPSET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVPWarlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "PVPSET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVPWarrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "PVPSET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVP70Druid1"] = {
        Title = BabbleClass["Druid"];
        Next_Page = "PVP70Druid2";
        Next_Title = BabbleClass["Druid"];
        Back_Page = "PVP70SET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVP70Druid2"] = {
        Title = BabbleClass["Druid"];
        Prev_Page = "PVP70Druid1";
        Prev_Title = BabbleClass["Druid"];
        Back_Page = "PVP70SET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVP70Hunter"] = {
        Title = BabbleClass["Hunter"];
        Back_Page = "PVP70SET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVP70Mage"] = {
        Title = BabbleClass["Mage"];
        Back_Page = "PVP70SET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVP70Paladin1"] = {
        Title = BabbleClass["Paladin"];
        Next_Page = "PVP70Paladin2";
        Next_Title = BabbleClass["Paladin"];
        Back_Page = "PVP70SET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVP70Paladin2"] = {
        Title = BabbleClass["Paladin"];
        Prev_Page = "PVP70Paladin1";
        Prev_Title = BabbleClass["Paladin"];
        Back_Page = "PVP70SET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVP70Priest"] = {
        Title = BabbleClass["Priest"];
        Back_Page = "PVP70SET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVP70Rogue"] = {
        Title = BabbleClass["Rogue"];
        Back_Page = "PVP70SET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVP70Shaman1"] = {
        Title = BabbleClass["Shaman"];
        Next_Page = "PVP70Shaman2";
        Next_Title = BabbleClass["Shaman"];
        Back_Page = "PVP70SET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVP70Shaman2"] = {
        Title = BabbleClass["Shaman"];
        Prev_Page = "PVP70Shaman1";
        Prev_Title = BabbleClass["Shaman"];
        Back_Page = "PVP70SET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVP70Warlock"] = {
        Title = BabbleClass["Warlock"];
        Back_Page = "PVP70SET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["PVP70Warrior"] = {
        Title = BabbleClass["Warrior"];
        Back_Page = "PVP70SET";
        Back_Title = AL["PvP Armor Sets"];
        };
    ["DS3Hallowed"] = {
        Title = AL["Hallowed Raiment"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DS3Incanter"] = {
        Title = AL["Incanter's Regalia"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DS3Mana"] = {
        Title = AL["Mana-Etched Regalia"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DS3Oblivion"] = {
        Title = AL["Oblivion Raiment"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DS3Assassin"] = {
        Title = AL["Assassination Armor"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DS3Moonglade"] = {
        Title = AL["Moonglade Raiment"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DS3Wastewalker"] = {
        Title = AL["Wastewalker Armor"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DS3Beast"] = {
        Title = AL["Beast Lord Armor"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DS3Desolation"] = {
        Title = AL["Desolation Battlegear"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DS3Tidefury"] = {
        Title = AL["Tidefury Raiment"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DS3Bold"] = {
        Title = AL["Bold Armor"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DS3Doom"] = {
        Title = AL["Doomplate Battlegear"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DS3Right"] = {
        Title = AL["Righteous Armor"];
        Back_Page = "DS3SET";
        Back_Title = AL["Dungeon 3 Sets"];
        };
    ["DEADMINES"] = {
        Title = AL["Defias Leather"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["WAILING"] = {
        Title = AL["Embrace of the Viper"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["SCARLET"] = {
        Title = AL["Chain of the Scarlet Crusade"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["BLACKROCKD"] = {
        Title = AL["The Gladiator"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["IRONWEAVE"] = {
        Title = AL["Ironweave Battlesuit"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["ScholoCloth"] = {
        Title = AL["Necropile Raiment"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["ScholoLeather"] = {
        Title = AL["Cadaverous Garb"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["ScholoMail"] = {
        Title = AL["Bloodmail Regalia"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["ScholoPlate"] = {
        Title = AL["Deathbone Guardian"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["STRAT"] = {
        Title = AL["The Postmaster"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["ScourgeInvasion"] = {
        Title = AL["Scourge Invasion"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["ShardOfGods"] = {
        Title = AL["Shard of the Gods"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["ZGRings"] = {
        Title = AL["Zul'Gurub Rings"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["SpiritofEskhandar"] = {
        Title = AL["Spirit of Eskhandar"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["HakkariBlades"] = {
        Title = AL["The Twin Blades of Hakkari"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["PrimalBlessing"] = {
        Title = AL["Primal Blessing"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["DalRend"] = {
        Title = AL["Dal'Rend's Arms"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["SpiderKiss"] = {
        Title = AL["Spider's Kiss"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["TwinStars"] = {
        Title = AL["The Twin Stars"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["AzzinothBlades"] = {
        Title = AL["The Twin Blades of Azzinoth"];
        Back_Page = "PRE60SET";
        Back_Title = AL["Pre 60 Sets"];
        };
    ["ImperialPlate"] = {
        Title = AL["Imperial Plate"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["TheDarksoul"] = {
        Title = AL["The Darksoul"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["FelIronPlate"] = {
        Title = AL["Fel Iron Plate"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["AdamantiteB"] = {
        Title = AL["Adamantite Battlegear"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["FlameG"] = {
        Title = AL["Flame Guard"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["EnchantedAdaman"] = {
        Title = AL["Enchanted Adamantite Armor"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["KhoriumWard"] = {
        Title = AL["Khorium Ward"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["FaithFelsteel"] = {
        Title = AL["Faith in Felsteel"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["BurningRage"] = {
        Title = AL["Burning Rage"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["BloodsoulEmbrace"] = {
        Title = AL["Bloodsoul Embrace"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["FelIronChain"] = {
        Title = AL["Fel Iron Chain"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["BloodvineG"] = {
        Title = AL["Bloodvine Garb"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["NeatherVest"] = {
        Title = AL["Netherweave Vestments"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["ImbuedNeather"] = {
        Title = AL["Imbued Netherweave"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["ArcanoVest"] = {
        Title = AL["Arcanoweave Vestments"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["TheUnyielding"] = {
        Title = AL["The Unyielding"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["WhitemendWis"] = {
        Title = AL["Whitemend Wisdom"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["SpellstrikeInfu"] = {
        Title = AL["Spellstrike Infusion"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["BattlecastG"] = {
        Title = AL["Battlecast Garb"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["SoulclothEm"] = {
        Title = AL["Soulcloth Embrace"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["PrimalMoon"] = {
        Title = AL["Primal Mooncloth"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["ShadowEmbrace"] = {
        Title = AL["Shadow's Embrace"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["SpellfireWrath"] = {
        Title = AL["Wrath of Spellfire"];
        Back_Page = "CRAFTSET";
        Back_Title = AL["Crafted Sets"];
        };
    ["VolcanicArmor"] = {
        Title = AL["Volcanic Armor"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["IronfeatherArmor"] = {
        Title = AL["Ironfeather Armor"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["StormshroudArmor"] = {
        Title = AL["Stormshroud Armor"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["DevilsaurArmor"] = {
        Title = AL["Devilsaur Armor"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["BloodTigerH"] = {
        Title = AL["Blood Tiger Harness"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["PrimalBatskin"] = {
        Title = AL["Primal Batskin"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["WildDraenishA"] = {
        Title = AL["Wild Draenish Armor"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["ThickDraenicA"] = {
        Title = AL["Thick Draenic Armor"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["FelSkin"] = {
        Title = AL["Fel Skin"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["SClefthoof"] = {
        Title = AL["Strength of the Clefthoof"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["GreenDragonM"] = {
        Title = AL["Green Dragon Mail"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["BlueDragonM"] = {
        Title = AL["Blue Dragon Mail"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["BlackDragonM"] = {
        Title = AL["Black Dragon Mail"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["ScaledDraenicA"] = {
        Title = AL["Scaled Draenic Armor"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["FelscaleArmor"] = {
        Title = AL["Felscale Armor"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["FelstalkerArmor"] = {
        Title = AL["Felstalker Armor"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["NetherFury"] = {
        Title = AL["Fury of the Nether"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["PrimalIntent"] = {
        Title = AL["Primal Intent"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["WindhawkArmor"] = {
        Title = AL["Windhawk Armor"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["NetherscaleArmor"] = {
        Title = AL["Netherscale Armor"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["NetherstrikeArmor"] = {
        Title = AL["Netherstrike Armor"];
        Back_Page = "CRAFTSET2";
        Back_Title = AL["Crafted Sets"];
        };
    ["ZGTrash1"] = {
        Title = AtlasLoot_TableNames["ZGTrash1"][1];
        Next_Page = "ZGTrash2";
        Next_Title = AtlasLoot_TableNames["ZGTrash2"][1];
        };
    ["ZGTrash2"] = {
        Title = AtlasLoot_TableNames["ZGTrash2"][1];
        Prev_Page = "ZGTrash1";
        Prev_Title = AtlasLoot_TableNames["ZGTrash1"][1];
        };
    ["AQ40Trash1"] = {
        Title = AtlasLoot_TableNames["AQ40Trash1"][1];
        Next_Page = "AQ40Trash2";
        Next_Title = AtlasLoot_TableNames["AQ40Trash2"][1];
        };
    ["AQ40Trash2"] = {
        Title = AtlasLoot_TableNames["AQ40Trash2"][1];
        Prev_Page = "AQ40Trash1";
        Prev_Title = AtlasLoot_TableNames["AQ40Trash1"][1];
        };
    ["CraftedWeapons1"] = {
        Title = AL["Crafted Epic Weapons"];
        Next_Page = "CraftedWeapons2";
        Next_Title = AL["Crafted Epic Weapons"];
        };
    ["CraftedWeapons2"] = {
        Title = AL["Crafted Epic Weapons"];
        Prev_Page = "CraftedWeapons1";
        Prev_Title = AL["Crafted Epic Weapons"];
        };
    ["HardModeToken"] = {
        Title = AL["Lvl 70 Instance Token Rewards"];
        Next_Page = "HardModeToken3";
        Next_Title = AL["Lvl 70 Instance Token Rewards"];
        };
    ["HardModeToken3"] = {
        Title = AL["Lvl 70 Instance Token Rewards"];
        Next_Page = "HardModeToken2";
        Next_Title = AL["Lvl 70 Instance Token Rewards"];
        Prev_Page = "HardModeToken";
        Prev_Title = AL["Lvl 70 Instance Token Rewards"];
        };
    ["HardModeToken2"] = {
        Title = AL["Lvl 70 Instance Token Rewards"];
        Prev_Page = "HardModeToken3";
        Prev_Title = AL["Lvl 70 Instance Token Rewards"];
        };
};